/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2497;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_6862;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.Util;

public class MaxToolStat
implements IToolStat<Integer> {
    private final ToolStatId name;
    private final int defaultValue;
    private final IntFunction<class_2561> displayName;
    @Nullable
    private final class_6862<class_1792> tag;

    public MaxToolStat(ToolStatId name, int defaultValue, IntFunction<class_2561> displayName) {
        this(name, defaultValue, displayName, null);
    }

    @Override
    public boolean supports(class_1792 item) {
        return this.tag == null || RegistryHelper.contains(this.tag, item);
    }

    @Override
    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Integer clamp(Integer value) {
        return class_3532.method_15340((int)value, (int)0, (int)Integer.MAX_VALUE);
    }

    @Override
    public TierBuilder makeBuilder() {
        return new TierBuilder();
    }

    @Override
    public void update(ModifierStatsBuilder builder, Integer value) {
        builder.updateStat(this, b -> {
            b.tier = Math.max(b.tier, value);
        });
    }

    @Override
    public Integer build(Object builder, Integer value) {
        return Math.max(value, ((TierBuilder)builder).tier);
    }

    @Override
    @Nullable
    public Integer read(class_2520 tag) {
        if (TagUtil.isNumeric(tag)) {
            return ((class_2514)tag).method_10701();
        }
        return null;
    }

    @Override
    @Nullable
    public class_2520 write(Integer value) {
        return class_2497.method_23247((int)value);
    }

    @Override
    public Integer deserialize(JsonElement json) {
        return class_3518.method_15257((JsonElement)json, (String)this.getName().toString());
    }

    @Override
    public JsonElement serialize(Integer value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Integer fromNetwork(class_2540 buffer) {
        return buffer.method_10816();
    }

    @Override
    public void toNetwork(class_2540 buffer, Integer value) {
        buffer.method_10804(value.intValue());
    }

    @Override
    public class_2561 formatValue(Integer number) {
        return class_2561.method_43471((String)Util.makeTranslationKey("tool_stat", this.getName())).method_10852(this.displayName.apply(number));
    }

    public String toString() {
        return "TierToolStat{" + this.name + "}";
    }

    public MaxToolStat(ToolStatId name, int defaultValue, IntFunction<class_2561> displayName, @Nullable class_6862<class_1792> tag) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.displayName = displayName;
        this.tag = tag;
    }

    @Override
    public ToolStatId getName() {
        return this.name;
    }

    protected static class TierBuilder {
        private int tier = 0;

        protected TierBuilder() {
        }
    }
}

